--[[---------------------------------------------------------------------------
	Chocolatier Two Factory Paused Dialog
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local self = gDialogTable.factory
local missing = gDialogTable.missing
local char = gDialogTable.char

local x = (600 - ui.charW) / 2 - 50
local dx = (600 - ui.charW) / 2
local y = 80

local colcount = table.getn(missing)
if colcount > 3 then
	x = 20
	colcount = bsgFloor(colcount / 2 + .5)
end

local count = 0
local missingInfo = {}
for _,ing in ipairs(missing) do
	table.insert(missingInfo, ing:Rollover(x,y))
	table.insert(missingInfo, Text { x=x+ui.itemWidth+2, y=y, w=dx,h=ui.itemHeight, label=LabelString(ing.name), font=dialogFont, flags=kVAlignCenter+kHAlignLeft })
	y = y + ui.itemHeight
	count = count + 1
	if count == colcount then
		x = x + dx
		y = 150
	end
end

-------------------------------------------------------------------------------

local width=600
local height=280

MakeDialog
{
	Frame
	{
		x=100+ui.xOffset,y=50+ui.xOffset,w=width,h=height,
		
		Text { x=0,y=0,w=width-ui.charW,h=70, label="factory_noingredients", font=dialogFont, },
		Group(missingInfo),
		
		TextButton { x=(width-ui.charW-ui.devButtonW)/2,y=kMax-40, name="ok", close=true, label="ok", default=true },
	},
	char:Visual(ui.screenWidth-100-ui.charW+ui.xOffset, ui.yOffset, charNameFontDark),
}
